/** @file   Font.h
 * @brief   Declaration of Font class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/08 22:00:11 $
 * @author  Tomi Lamminsaari
 */


#ifndef H_FONT_H
#define H_FONT_H

#include <string>
#include <allegro.h>
#include "eng2d_dll.h"
#include "eng2d_Exception.h"


namespace eng2d {

/** @class  Font
 * @brief   Provides simple way to load and use bitmap fonts.
 * @author  Tomi Lamminsaari
 *
 * Fonts-class provides simple and "ugly" way to use bitmap fonts.
 *
 * A Font-file is an Allegro datafile that has the FONT as its first element.
 */
class DLLIMPORT Font
{
public:

  ///
  /// Constructors, destructor and operators
  /// ======================================


  /** Constructs new Font that has no data.
   */
  Font();
  
  /** Constructs new Font and loads its data from file.
   * @param     filename        Name of the datafile that has the font data.
   * @exception xIoError        Thrown if we fail to load the font.
   */
  Font( const std::string& filename ) throw ( xIoError );
  
  /** Destructor.
   */
  ~Font();


  ///
  /// Methods
  /// =======
  
  /** Loads new Font data.
   * @param     file              Name of the datafile.
   * @return    0 if successful. Negative if fails.
   */
  int open( const std::string& file );
  
  /** Closes the current font.
   */
  void close();
  
  
  ///
  /// Public GET-methods
  /// ==================
  
  /** Returns the pointer to FONT that can be used with Allegro's
   * text routines.
   * @return    Pointer to font or nullpointer if there is no font.
   */
  FONT* al_FONT() const;
  
  
private:

  /** Private methods **/
  
  Font(const Font& rObject);
  Font& operator = (const Font& rObject);
  
  
  /** Members **/

  // The datafile that should has FONT as its first element.
  DATAFILE*   m_pDatafile;
};

};  // end of namespace

#endif
